#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Tue Dec 10 09:16:43 2019

@author: yannbrunel
"""
import numpy as np
import matplotlib.pyplot as plt
#%%

t0, tf = 0., 100. # bornes de l'intervalle de temps pour la résolution
N = 1000 # nombre de pas
t = np.linspace(t0,tf,N+1) # liste des dates pour le calcul des solutions aprochées
x0=0 #intialisation x(0)=0
C0=1
Tau=10
def f(C,t):
    return -C/Tau

#%%
def euler(g,x0,t): # méthode d'Euler 
    h = t[1]-t[0] # pas constant, choisi comme distance entre les deux premières valeurs de la liste de t
    N = len(t)  # on recalcule N en local pour le cas général 
    x = np.zeros(N) # intialisation obligatoire du tableau numpy, crée un tableau de longueur N rempli de 0
    x[0] = x0 # initialisation de la résolution
    for i in range(N-1):
        x[i+1] = x[i]+h*g(x[i],t[i]) # définit x[i+1] par Euler
    return x # la boucle précédente sert à calculer les valeurs de x, la fin définit x comme fonction solution de la fonction eurler

#%%
solC = euler(f,C0,t)
plt.figure()
plt.plot(t,solC,'b-',label='Euler avec N = '+str(N))
plt.legend(loc='best') 
plt.xlabel('t') ; plt.ylabel('$Concentration$')
plt.grid()
plt.show()